#!/bin/sh
################################################################################
# This software has been developed by Advanced Driver Information Technology
# Copyright(c) 2019 Advanced Driver Information Technology GmbH,
# Advanced Driver Information Technology Corporation, Robert Bosch GmbH,
# Robert Bosch Car Multimedia GmbH and DENSO Corporation.
# All rights reserved
################################################################################

SRC_MANIFEST=./aarch64le-nto-build/install_manifest_base.txt
BUILD_FILE=adit.dlt-daemon.build

sort -o $BUILD_FILE $SRC_MANIFEST
sed -i -r '/lib64\/lib.*\.so[\.]?[0-9]*$/d' $BUILD_FILE

sed -i 's:^/:[uid=0 gid=0 perms=0644] :' $BUILD_FILE
sed -i 's:\(perms=\).*\(\] usr/bin\):\10755\2:' $BUILD_FILE
sed -i 's:\(usr/bin/.*\):\1=aarch64le/\1:' $BUILD_FILE
sed -i 's:\(lib64/.*\):\1=aarch64le/\1:' $BUILD_FILE
sed -i 's:\(etc/.*\):\1=aarch64le/\1:' $BUILD_FILE

cat >> $BUILD_FILE << EOF
[uid=0 gid=0 perms=0666] /var/opt/bosch/processes/slm/config/SLMdlt-daemon.xml=aarch64le/etc/system/config/slm/SLMdlt-daemon.xml
[uid=0 gid=0 perms=0666] /var/opt/bosch/processes/slm/config/SLMdlt-qnx-system.xml=aarch64le/etc/system/config/slm/SLMdlt-qnx-system.xml
[type=link] lib64/libdlt.so.2=`basename $(grep libdlt.so.2. $SRC_MANIFEST)`
[type=link] lib64/libdlt.so=libdlt.so.2
EOF

cp $BUILD_FILE $FILESETS/
